//
//  BPProjectUserProxy.h
//  BISubstrate
//
//  Created by Alykhan Jetha on 10-04-14.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BIUser;
@class BIProject;
@class BIProjectUser;

/*!
 A convenience class for use in the UI. Makes it easy to use bindings in the Project Card -> Workers pane.
 Objects are not retained to prevent circular references. These objects should be temporary.
 */
@interface BPProjectUserProxy : NSObject {
	BIProject *project;
	BIUser *user;
	BIProjectUser *projectUser;
}

@property (retain) BIProjectUser *projectUser;
@property (assign) BIProject *project;
@property (assign) BIUser *user;

- (BOOL)userIsInProject;
- (void)setUserIsInProject:(BOOL)flag;

@end
